#ifndef BSPEXP_H
#define BSPEXP_H

#include "rwcommon.h"
#include "material.h"
#include "remapper.h"

class CBspDlg;

class BSPExport : public SceneExport
{
public:
                    BSPExport();                        /* Constructor */
                    ~BSPExport();                       /* Destructor */
    int             ExtCount();                         /* Number of extensions supported */
    const TCHAR *   Ext(int n);                         /* Extension #n (i.e. "3DS") */
    const TCHAR *   LongDesc();                         /* Long ASCII description (i.e. "Autodesk 3D Studio File") */
    const TCHAR *   ShortDesc();                        /* Short ASCII description (i.e. "3D Studio") */
    const TCHAR *   AuthorName();                       /* ASCII Author name */
    const TCHAR *   CopyrightMessage();                 /* ASCII Copyright message  */
    const TCHAR *   OtherMessage1();                    /* Other message #1 */
    const TCHAR *   OtherMessage2();                    /* Other message #2 */
    unsigned int    Version();                          /* Version number * 100 (i.e. v3.01 = 301) */
    void            ShowAbout(HWND hWnd);               /* Show DLL's "About..." box */
    int             DoExport(const TCHAR *name, 
                             ExpInterface *ei,Interface *i, BOOL suppressPrompts, DWORD options); /* Export file */

private:
    RwLib *             m_rwlib;
    RtWorldImport *     m_importWorld;
    float               m_nScaleFactor;
    float               m_nWorldSectorSize;
    int                 m_nWorldSectorMaxPolys;    
    Mtl *               m_nodeMaterial;
    Matrix3             m_nodeLTM;
    Matrix3             m_nodeLTMNoTrans;
    BOOL                m_triStripMesh;
    BOOL                m_noAlphaInOverlap;
    float               m_maxSectorOverlap;
    BOOL                m_limitUVs;
    int                 m_limitUVMax;
    INode *             rootNode;    
    INode *             m_currentNode;
    char *              m_currentNodeName;
    /* hack to get one off nohsworld allocation */
    int                 m_numAddedTriangles;
    int                 m_numAddedVertices;
    int                 m_currentMeshVertexIndOffset;
    ReMapper            m_reMapper;
    int                 m_maxPlaneCheck;
    float               m_weldThreshold;
    float               m_weldThresholdUV;
    BOOL                m_backfaceNormals;
    BOOL                m_2SidedMaterials;
    BOOL                m_colorVertexPrelight;
    BOOL                m_weldVertices;
    RwInt32             m_texturenameCase;
    BOOL                m_conditionGeometry;
    BOOL                m_exportNormals;
    RwV3d               m_globalWorldOffset;
    BOOL                m_generateReportFile;
    BOOL                m_displayReport;
    WarningList         m_WarningsList;

    BOOL                    AddNodeToWorld(INode *node);
    BOOL                    AddMeshToWorld(Mesh *mesh);
    BOOL                    SetVertices(Mesh *mesh);    
    BOOL                    SetFaces(Mesh *mesh);    
    BOOL                    SaveTheWorld(const char *filename);    
    void                    AddPolyVertCountInNodeAndChildren(INode *node, RwInt32 *polys, RwInt32 *verts);
};

class BSPClassDesc:public ClassDesc
{
public:    
    int             IsPublic() { return 1; }
    void *          Create(BOOL loading = FALSE) { return new BSPExport; }
    const TCHAR *   ClassName() { return _T("BSP"); }
    SClass_ID       SuperClassID() { return SCENE_EXPORT_CLASS_ID; }
    Class_ID        ClassID() { return Class_ID(0x4f681c22, 0x7682242b); }
    const TCHAR *   Category() { return _T("BSP Exporter"); }
};

#endif /* BSPEXP_H */
